﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;  
using VeteransAffairs.Registries.BusinessManager;

public partial class ReportComprehensiveFacilityDetail : System.Web.UI.Page
{
    private UserAccountManager _currentUser;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            if (!IsPostBack)
            {
                SetDropDownListVisnId();
                ReportViewer1.Visible = false;
            }

            if (DropDownListVisnID.SelectedIndex == 0 || DropDownListFacility.SelectedIndex == 0)
            {
                ButtonRunReport.Enabled = false;
            }
            else
                ButtonRunReport.Enabled = true;

            ReportViewer1.Toggle += new System.ComponentModel.CancelEventHandler(ReportViewer1_Toggle);

            ReportViewer1.Visible = false;
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        if (DropDownListVisnID.SelectedIndex > 0 &&
                DropDownListFacility.SelectedIndex > 0)
        {
            //ObjectDataSource1.Select();
            //ObjectDataSource1.DataBind();
            //ReportViewer1.DataBind();
            //ReportViewer1.Visible = true;
            //ReportViewer1.LocalReport.Refresh();

            List<ReportParameter> _reportParameters = new List<ReportParameter>();
    
            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            UserAccountManager thisUser = (UserAccountManager)HttpContext.Current.User;
            ReportParameter reportParam = new ReportParameter("Username", thisUser.FullName);
            ReportParameter reportParamVisn = new ReportParameter("VisnId", DropDownListVisnID.SelectedValue); //"VISN 7");
            ReportParameter reportParamFacility = new ReportParameter("FacilityID", DropDownListFacility.SelectedValue); //"VISN 7");

            ReportViewer1.Reset();

            _reportParameters.Clear();
            _reportParameters.Add(reportParam);
            _reportParameters.Add(reportParamVisn);
            _reportParameters.Add(reportParamFacility);

            ReportViewer1.ServerReport.ReportPath = "ReportComprehensiveFacilityDetail";

            //var config = RegistriesConfigurations.GetConfig();

            ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
            //ReportViewer1.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
            if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
            //if (ReportViewer1.ServerReport.ReportPath.IndexOf(config.BaseReportPath, 0) == -1)
            {
                ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                //ReportViewer1.ServerReport.ReportPath = config.BaseReportPath + ReportViewer1.ServerReport.ReportPath;
            }
            ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());

            ReportViewer1.ProcessingMode = ProcessingMode.Remote;

            ReportViewer1.Visible = true;
            ReportViewer1.ServerReport.Refresh();

        }
        else 
        {
            ReportViewer1.Visible = false;
        }
    }
    protected void DropDownListVisnID_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (DropDownListVisnID.SelectedIndex != 0)
        {
            SetDropDownListFacility();
            ButtonRunReport.Enabled = false;
            ReportViewer1.Visible = false;
        }
        else
        {
            DropDownListFacility.Items.Clear();
        }
    }

    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    protected void ObjectDataSourcePermittedStations_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
    }
    private void ReportViewer1_Toggle(object sender, System.ComponentModel.CancelEventArgs e)
    {
        Page.RegisterStartupScript("scrollup", "<script language=javascript>window.scrollTo(0,400);</script>");
    }
    private void SetDropDownListVisnId()
    {
        if (!_currentUser.IsInRole(16))
        {
            DropDownListVisnID.DataSource = ObjectDataSourcePermittedStationVISNs;
            DropDownListVisnID.DataBind();
            DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
        }
    }
    private void SetDropDownListFacility()
    {
        if (DropDownListVisnID.SelectedIndex != 0)
        {
            DropDownListFacilityDiv1.Visible = true;
            DropDownListFacilityDiv2.Visible = true;

            if (!_currentUser.IsInRole(18))
            {
                DropDownListFacility.DataSource = ObjectDataSource2;
            }
            else
            {
                DropDownListFacility.DataSource = ObjectDataSourcePermittedStations;
            }

            DropDownListFacility.DataBind();
            DropDownListFacility.Items.Insert(0, new ListItem("Select One", "000"));

            DropDownListFacility.SelectedIndex = 0;
        }
    }
    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }
}
